<?php
/**
 * The template to display the widgets area in the header
 *
 * @package GAT
 * @since GAT 1.0
 */

// Header sidebar
$gat_header_name    = gat_get_theme_option( 'header_widgets' );
$gat_header_present = ! gat_is_off( $gat_header_name ) && is_active_sidebar( $gat_header_name );
if ( $gat_header_present ) {
	gat_storage_set( 'current_sidebar', 'header' );
	$gat_header_wide = gat_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $gat_header_name ) ) {
		dynamic_sidebar( $gat_header_name );
	}
	$gat_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $gat_widgets_output ) ) {
		$gat_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $gat_widgets_output );
		$gat_need_columns   = strpos( $gat_widgets_output, 'columns_wrap' ) === false;
		if ( $gat_need_columns ) {
			$gat_columns = max( 0, (int) gat_get_theme_option( 'header_columns' ) );
			if ( 0 == $gat_columns ) {
				$gat_columns = min( 6, max( 1, gat_tags_count( $gat_widgets_output, 'aside' ) ) );
			}
			if ( $gat_columns > 1 ) {
				$gat_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $gat_columns ) . ' widget', $gat_widgets_output );
			} else {
				$gat_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $gat_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'gat_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $gat_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $gat_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'gat_action_before_sidebar', 'header' );
				gat_show_layout( $gat_widgets_output );
				do_action( 'gat_action_after_sidebar', 'header' );
				if ( $gat_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $gat_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'gat_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
