<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package GAT
 * @since GAT 1.0.06
 */

$gat_header_css   = '';
$gat_header_image = get_header_image();
$gat_header_video = gat_get_header_video();
if ( ! empty( $gat_header_image ) && gat_trx_addons_featured_image_override( is_singular() || gat_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$gat_header_image = gat_get_current_mode_image( $gat_header_image );
}

$gat_header_id = gat_get_custom_header_id();
$gat_header_meta = get_post_meta( $gat_header_id, 'trx_addons_options', true );
if ( ! empty( $gat_header_meta['margin'] ) ) {
	gat_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( gat_prepare_css_value( $gat_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $gat_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $gat_header_id ) ) ); ?>
				<?php
				echo ! empty( $gat_header_image ) || ! empty( $gat_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $gat_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $gat_header_image ) {
					echo ' ' . esc_attr( gat_add_inline_css_class( 'background-image: url(' . esc_url( $gat_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( gat_is_on( gat_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight gat-full-height';
				}
				$gat_header_scheme = gat_get_theme_option( 'header_scheme' );
				if ( ! empty( $gat_header_scheme ) && ! gat_is_inherit( $gat_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $gat_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $gat_header_video ) ) {
		get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'gat_action_show_layout', $gat_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
