<?php
/**
 * The template to display the site logo in the footer
 *
 * @package GAT
 * @since GAT 1.0.10
 */

// Logo
if ( gat_is_on( gat_get_theme_option( 'logo_in_footer' ) ) ) {
	$gat_logo_image = gat_get_logo_image( 'footer' );
	$gat_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $gat_logo_image['logo'] ) || ! empty( $gat_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $gat_logo_image['logo'] ) ) {
					$gat_attr = gat_getimagesize( $gat_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $gat_logo_image['logo'] ) . '"'
								. ( ! empty( $gat_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $gat_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'gat' ) . '"'
								. ( ! empty( $gat_attr[3] ) ? ' ' . wp_kses_data( $gat_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $gat_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $gat_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
