<?php
/**
 * The Header: Logo and main menu
 *
 * @package GAT
 * @since GAT 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( gat_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'gat_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'gat_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('gat_action_body_wrap_attributes'); ?>>

		<?php do_action( 'gat_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'gat_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('gat_action_page_wrap_attributes'); ?>>

			<?php do_action( 'gat_action_page_wrap_start' ); ?>

			<?php
			$gat_full_post_loading = ( gat_is_singular( 'post' ) || gat_is_singular( 'attachment' ) ) && gat_get_value_gp( 'action' ) == 'full_post_loading';
			$gat_prev_post_loading = ( gat_is_singular( 'post' ) || gat_is_singular( 'attachment' ) ) && gat_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $gat_full_post_loading && ! $gat_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="gat_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'gat_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'gat' ); ?></a>
				<?php if ( gat_sidebar_present() ) { ?>
				<a class="gat_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'gat_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'gat' ); ?></a>
				<?php } ?>
				<a class="gat_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'gat_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'gat' ); ?></a>

				<?php
				do_action( 'gat_action_before_header' );

				// Header
				$gat_header_type = gat_get_theme_option( 'header_type' );
				if ( 'custom' == $gat_header_type && ! gat_is_layouts_available() ) {
					$gat_header_type = 'default';
				}
				get_template_part( apply_filters( 'gat_filter_get_template_part', "templates/header-" . sanitize_file_name( $gat_header_type ) ) );

				// Side menu
				if ( in_array( gat_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'gat_action_after_header' );

			}
			?>

			<?php do_action( 'gat_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( gat_is_off( gat_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $gat_header_type ) ) {
						$gat_header_type = gat_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $gat_header_type && gat_is_layouts_available() ) {
						$gat_header_id = gat_get_custom_header_id();
						if ( $gat_header_id > 0 ) {
							$gat_header_meta = gat_get_custom_layout_meta( $gat_header_id );
							if ( ! empty( $gat_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$gat_footer_type = gat_get_theme_option( 'footer_type' );
					if ( 'custom' == $gat_footer_type && gat_is_layouts_available() ) {
						$gat_footer_id = gat_get_custom_footer_id();
						if ( $gat_footer_id ) {
							$gat_footer_meta = gat_get_custom_layout_meta( $gat_footer_id );
							if ( ! empty( $gat_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'gat_action_page_content_wrap_class', $gat_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'gat_filter_is_prev_post_loading', $gat_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( gat_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'gat_action_page_content_wrap_data', $gat_prev_post_loading );
			?>>
				<?php
				do_action( 'gat_action_page_content_wrap', $gat_full_post_loading || $gat_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'gat_filter_single_post_header', gat_is_singular( 'post' ) || gat_is_singular( 'attachment' ) ) ) {
					if ( $gat_prev_post_loading ) {
						if ( gat_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'gat_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$gat_path = apply_filters( 'gat_filter_get_template_part', 'templates/single-styles/' . gat_get_theme_option( 'single_style' ) );
					if ( gat_get_file_dir( $gat_path . '.php' ) != '' ) {
						get_template_part( $gat_path );
					}
				}

				// Widgets area above page
				$gat_body_style   = gat_get_theme_option( 'body_style' );
				$gat_widgets_name = gat_get_theme_option( 'widgets_above_page' );
				$gat_show_widgets = ! gat_is_off( $gat_widgets_name ) && is_active_sidebar( $gat_widgets_name );
				if ( $gat_show_widgets ) {
					if ( 'fullscreen' != $gat_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					gat_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $gat_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'gat_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $gat_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'gat_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'gat_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="gat_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( gat_is_singular( 'post' ) || gat_is_singular( 'attachment' ) )
							&& $gat_prev_post_loading 
							&& gat_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'gat_action_between_posts' );
						}

						// Widgets area above content
						gat_create_widgets_area( 'widgets_above_content' );

						do_action( 'gat_action_page_content_start_text' );
