<div class="front_page_section front_page_section_contacts<?php
	$gat_scheme = gat_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $gat_scheme ) && ! gat_is_inherit( $gat_scheme ) ) {
		echo ' scheme_' . esc_attr( $gat_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( gat_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( gat_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$gat_css      = '';
		$gat_bg_image = gat_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $gat_bg_image ) ) {
			$gat_css .= 'background-image: url(' . esc_url( gat_get_attachment_url( $gat_bg_image ) ) . ');';
		}
		if ( ! empty( $gat_css ) ) {
			echo ' style="' . esc_attr( $gat_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$gat_anchor_icon = gat_get_theme_option( 'front_page_contacts_anchor_icon' );
	$gat_anchor_text = gat_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $gat_anchor_icon ) || ! empty( $gat_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $gat_anchor_icon ) ? ' icon="' . esc_attr( $gat_anchor_icon ) . '"' : '' )
									. ( ! empty( $gat_anchor_text ) ? ' title="' . esc_attr( $gat_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( gat_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' gat-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$gat_css      = '';
			$gat_bg_mask  = gat_get_theme_option( 'front_page_contacts_bg_mask' );
			$gat_bg_color_type = gat_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $gat_bg_color_type ) {
				$gat_bg_color = gat_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $gat_bg_color_type ) {
				$gat_bg_color = gat_get_scheme_color( 'bg_color', $gat_scheme );
			} else {
				$gat_bg_color = '';
			}
			if ( ! empty( $gat_bg_color ) && $gat_bg_mask > 0 ) {
				$gat_css .= 'background-color: ' . esc_attr(
					1 == $gat_bg_mask ? $gat_bg_color : gat_hex2rgba( $gat_bg_color, $gat_bg_mask )
				) . ';';
			}
			if ( ! empty( $gat_css ) ) {
				echo ' style="' . esc_attr( $gat_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$gat_caption     = gat_get_theme_option( 'front_page_contacts_caption' );
			$gat_description = gat_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $gat_caption ) || ! empty( $gat_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $gat_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $gat_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $gat_caption, 'gat_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $gat_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $gat_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $gat_description ), 'gat_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$gat_content = gat_get_theme_option( 'front_page_contacts_content' );
			$gat_layout  = gat_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $gat_layout && ( ! empty( $gat_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $gat_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $gat_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $gat_content, 'gat_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $gat_layout && ( ! empty( $gat_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$gat_sc = gat_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $gat_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $gat_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					gat_show_layout( do_shortcode( $gat_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $gat_layout && ( ! empty( $gat_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
