<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GAT
 * @since GAT 1.71.0
 */

$gat_template_args = get_query_var( 'gat_template_args' );
if ( ! is_array( $gat_template_args ) ) {
	$gat_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$gat_columns       = 1;

$gat_expanded      = ! gat_sidebar_present() && gat_get_theme_option( 'expand_content' ) == 'expand';

$gat_post_format   = get_post_format();
$gat_post_format   = empty( $gat_post_format ) ? 'standard' : str_replace( 'post-format-', '', $gat_post_format );

if ( is_array( $gat_template_args ) ) {
	$gat_columns    = empty( $gat_template_args['columns'] ) ? 1 : max( 1, $gat_template_args['columns'] );
	$gat_blog_style = array( $gat_template_args['type'], $gat_columns );
	if ( ! empty( $gat_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $gat_columns > 1 ) {
	    $gat_columns_class = gat_get_column_class( 1, $gat_columns, ! empty( $gat_template_args['columns_tablet']) ? $gat_template_args['columns_tablet'] : '', ! empty($gat_template_args['columns_mobile']) ? $gat_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $gat_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $gat_post_format ) );
	gat_add_blog_animation( $gat_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$gat_hover      = ! empty( $gat_template_args['hover'] ) && ! gat_is_inherit( $gat_template_args['hover'] )
							? $gat_template_args['hover']
							: gat_get_theme_option( 'image_hover' );
	$gat_components = ! empty( $gat_template_args['meta_parts'] )
							? ( is_array( $gat_template_args['meta_parts'] )
								? $gat_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $gat_template_args['meta_parts'] ) )
								)
							: gat_array_get_keys_by_value( gat_get_theme_option( 'meta_parts' ) );
	gat_show_post_featured( apply_filters( 'gat_filter_args_featured',
		array(
			'no_links'   => ! empty( $gat_template_args['no_links'] ),
			'hover'      => $gat_hover,
			'meta_parts' => $gat_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $gat_template_args['thumb_size'] )
								? $gat_template_args['thumb_size']
								: gat_get_thumb_size( 
								in_array( $gat_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( gat_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $gat_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$gat_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$gat_show_title = get_the_title() != '';
		$gat_show_meta  = count( $gat_components ) > 0 && ! in_array( $gat_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $gat_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'gat_filter_show_blog_categories', $gat_show_meta && in_array( 'categories', $gat_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'gat_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						gat_show_post_meta( apply_filters(
															'gat_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $gat_hover, 1
															)
											);
						?>
					</div>
					<?php
					$gat_components = gat_array_delete_by_value( $gat_components, 'categories' );
					do_action( 'gat_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'gat_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'gat_action_before_post_title' );
					if ( empty( $gat_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'gat_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $gat_template_args['excerpt_length'] ) && ! in_array( $gat_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$gat_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'gat_filter_show_blog_excerpt', empty( $gat_template_args['hide_excerpt'] ) && gat_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				gat_show_post_content( $gat_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'gat_filter_show_blog_meta', $gat_show_meta, $gat_components, 'band' ) ) {
			if ( count( $gat_components ) > 0 ) {
				do_action( 'gat_action_before_post_meta' );
				gat_show_post_meta(
					apply_filters(
						'gat_filter_post_meta_args', array(
							'components' => join( ',', $gat_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'gat_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'gat_filter_show_blog_readmore', ! $gat_show_title || ! empty( $gat_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $gat_template_args['no_links'] ) ) {
				do_action( 'gat_action_before_post_readmore' );
				gat_show_post_more_link( $gat_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'gat_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $gat_template_args ) ) {
	if ( ! empty( $gat_template_args['slider'] ) || $gat_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
