<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'gat_booked_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'gat_booked_theme_setup9', 9 );
	function gat_booked_theme_setup9() {
		if ( gat_exists_booked() ) {
			add_action( 'wp_enqueue_scripts', 'gat_booked_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'gat_booked_frontend_scripts', 10, 1 );
			add_action( 'wp_enqueue_scripts', 'gat_booked_frontend_scripts_responsive', 2000 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'gat_booked_frontend_scripts_responsive', 10, 1 );
			add_filter( 'gat_filter_merge_styles', 'gat_booked_merge_styles' );
			add_filter( 'gat_filter_merge_styles_responsive', 'gat_booked_merge_styles_responsive' );
		}
		if ( is_admin() ) {
			add_filter( 'gat_filter_tgmpa_required_plugins', 'gat_booked_tgmpa_required_plugins' );
			add_filter( 'gat_filter_theme_plugins', 'gat_booked_theme_plugins' );
		}
	}
}


// Filter to add in the required plugins list
if ( ! function_exists( 'gat_booked_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('gat_filter_tgmpa_required_plugins',	'gat_booked_tgmpa_required_plugins');
	function gat_booked_tgmpa_required_plugins( $list = array() ) {
		if ( gat_storage_isset( 'required_plugins', 'booked' ) && gat_storage_get_array( 'required_plugins', 'booked', 'install' ) !== false && gat_is_theme_activated() ) {
			$path = gat_get_plugin_source_path( 'plugins/booked/booked.zip' );
			if ( ! empty( $path ) || gat_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => gat_storage_get_array( 'required_plugins', 'booked', 'title' ),
					'slug'     => 'booked',
					'source'   => ! empty( $path ) ? $path : 'upload://booked.zip',
					'version'  => '2.4.3.1',
					'required' => false,
				);
			}
		}
		return $list;
	}
}


// Filter theme-supported plugins list
if ( ! function_exists( 'gat_booked_theme_plugins' ) ) {
	//Handler of the add_filter( 'gat_filter_theme_plugins', 'gat_booked_theme_plugins' );
	function gat_booked_theme_plugins( $list = array() ) {
		return gat_add_group_and_logo_to_slave( $list, 'booked', 'booked-' );
	}
}


// Check if plugin installed and activated
if ( ! function_exists( 'gat_exists_booked' ) ) {
	function gat_exists_booked() {
		return class_exists( 'booked_plugin' );
	}
}


// Return a relative path to the plugin styles depend the version
if ( ! function_exists( 'gat_booked_get_styles_dir' ) ) {
	function gat_booked_get_styles_dir( $file ) {
		$base_dir = 'plugins/booked/';
		return $base_dir
				. ( defined( 'BOOKED_VERSION' ) && version_compare( BOOKED_VERSION, '2.4', '<' ) && gat_get_folder_dir( $base_dir . 'old' )
					? 'old/'
					: ''
					)
				. $file;
	}
}


// Enqueue styles for frontend
if ( ! function_exists( 'gat_booked_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'gat_booked_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'gat_booked_frontend_scripts', 10, 1 );
	function gat_booked_frontend_scripts( $force = false ) {
		gat_enqueue_optimized( 'booked', $force, array(
			'css' => array(
				'gat-booked' => array( 'src' => gat_booked_get_styles_dir( 'booked.css' ) ),
			)
		) );
	}
}


// Enqueue responsive styles for frontend
if ( ! function_exists( 'gat_booked_frontend_scripts_responsive' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'gat_booked_frontend_scripts_responsive', 2000 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'gat_booked_frontend_scripts_responsive', 10, 1 );
	function gat_booked_frontend_scripts_responsive( $force = false ) {
		gat_enqueue_optimized_responsive( 'booked', $force, array(
			'css' => array(
				'gat-booked-responsive' => array( 'src' => gat_booked_get_styles_dir( 'booked-responsive.css' ), 'media' => 'all' ),
			)
		) );
	}
}


// Merge custom styles
if ( ! function_exists( 'gat_booked_merge_styles' ) ) {
	//Handler of the add_filter('gat_filter_merge_styles', 'gat_booked_merge_styles');
	function gat_booked_merge_styles( $list ) {
		$list[ gat_booked_get_styles_dir( 'booked.css' ) ] = false;
		return $list;
	}
}


// Merge responsive styles
if ( ! function_exists( 'gat_booked_merge_styles_responsive' ) ) {
	//Handler of the add_filter('gat_filter_merge_styles_responsive', 'gat_booked_merge_styles_responsive');
	function gat_booked_merge_styles_responsive( $list ) {
		$list[ gat_booked_get_styles_dir( 'booked-responsive.css' ) ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( gat_exists_booked() ) {
	$gat_fdir = gat_get_file_dir( gat_booked_get_styles_dir( 'booked-style.php' ) );
	if ( ! empty( $gat_fdir ) ) {
		require_once $gat_fdir;
	}
}
