<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package GAT
 * @since GAT 1.0
 */

$gat_template = apply_filters( 'gat_filter_get_template_part', gat_blog_archive_get_template() );

if ( ! empty( $gat_template ) && 'index' != $gat_template ) {

	get_template_part( $gat_template );

} else {

	gat_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$gat_stickies   = is_home()
								|| ( in_array( gat_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) gat_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$gat_post_type  = gat_get_theme_option( 'post_type' );
		$gat_args       = array(
								'blog_style'     => gat_get_theme_option( 'blog_style' ),
								'post_type'      => $gat_post_type,
								'taxonomy'       => gat_get_post_type_taxonomy( $gat_post_type ),
								'parent_cat'     => gat_get_theme_option( 'parent_cat' ),
								'posts_per_page' => gat_get_theme_option( 'posts_per_page' ),
								'sticky'         => gat_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $gat_stickies )
															&& count( $gat_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		gat_blog_archive_start();

		do_action( 'gat_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'gat_action_before_page_author' );
			get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'gat_action_after_page_author' );
		}

		if ( gat_get_theme_option( 'show_filters' ) ) {
			do_action( 'gat_action_before_page_filters' );
			gat_show_filters( $gat_args );
			do_action( 'gat_action_after_page_filters' );
		} else {
			do_action( 'gat_action_before_page_posts' );
			gat_show_posts( array_merge( $gat_args, array( 'cat' => $gat_args['parent_cat'] ) ) );
			do_action( 'gat_action_after_page_posts' );
		}

		do_action( 'gat_action_blog_archive_end' );

		gat_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
