<?php
$gat_slider_sc = gat_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $gat_slider_sc ) && strpos( $gat_slider_sc, '[' ) !== false && strpos( $gat_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( gat_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$gat_anchor_icon = gat_get_theme_option( 'front_page_title_anchor_icon' );
		$gat_anchor_text = gat_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $gat_anchor_icon ) || ! empty( $gat_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $gat_anchor_icon ) ? ' icon="' . esc_attr( $gat_anchor_icon ) . '"' : '' )
									. ( ! empty( $gat_anchor_text ) ? ' title="' . esc_attr( $gat_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $gat_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$gat_scheme = gat_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $gat_scheme ) && ! gat_is_inherit( $gat_scheme ) ) {
			echo ' scheme_' . esc_attr( $gat_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( gat_get_theme_option( 'front_page_title_paddings' ) );
		if ( gat_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$gat_css      = '';
		$gat_bg_image = gat_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $gat_bg_image ) ) {
			$gat_css .= 'background-image: url(' . esc_url( gat_get_attachment_url( $gat_bg_image ) ) . ');';
		}
		if ( ! empty( $gat_css ) ) {
			echo ' style="' . esc_attr( $gat_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$gat_anchor_icon = gat_get_theme_option( 'front_page_title_anchor_icon' );
		$gat_anchor_text = gat_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $gat_anchor_icon ) || ! empty( $gat_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $gat_anchor_icon ) ? ' icon="' . esc_attr( $gat_anchor_icon ) . '"' : '' )
									. ( ! empty( $gat_anchor_text ) ? ' title="' . esc_attr( $gat_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( gat_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' gat-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$gat_css      = '';
			$gat_bg_mask  = gat_get_theme_option( 'front_page_title_bg_mask' );
			$gat_bg_color_type = gat_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $gat_bg_color_type ) {
				$gat_bg_color = gat_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $gat_bg_color_type ) {
				$gat_bg_color = gat_get_scheme_color( 'bg_color', $gat_scheme );
			} else {
				$gat_bg_color = '';
			}
			if ( ! empty( $gat_bg_color ) && $gat_bg_mask > 0 ) {
				$gat_css .= 'background-color: ' . esc_attr(
					1 == $gat_bg_mask ? $gat_bg_color : gat_hex2rgba( $gat_bg_color, $gat_bg_mask )
				) . ';';
			}
			if ( ! empty( $gat_css ) ) {
				echo ' style="' . esc_attr( $gat_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$gat_caption = gat_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $gat_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $gat_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $gat_caption, 'gat_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$gat_description = gat_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $gat_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $gat_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $gat_description ), 'gat_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( gat_get_theme_option( 'front_page_title_button1_link' ) != '' || gat_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						gat_show_layout( gat_customizer_partial_refresh_front_page_title_button1_link() );
						gat_show_layout( gat_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
