<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package GAT
 * @since GAT 1.0
 */

// Page (category, tag, archive, author) title

if ( gat_need_page_title() ) {
	gat_sc_layouts_showed( 'title', true );
	gat_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								gat_show_post_meta(
									apply_filters(
										'gat_filter_post_meta_args', array(
											'components' => join( ',', gat_array_get_keys_by_value( gat_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', gat_array_get_keys_by_value( gat_get_theme_option( 'counters' ) ) ),
											'seo'        => gat_is_on( gat_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$gat_blog_title           = gat_get_blog_title();
							$gat_blog_title_text      = '';
							$gat_blog_title_class     = '';
							$gat_blog_title_link      = '';
							$gat_blog_title_link_text = '';
							if ( is_array( $gat_blog_title ) ) {
								$gat_blog_title_text      = $gat_blog_title['text'];
								$gat_blog_title_class     = ! empty( $gat_blog_title['class'] ) ? ' ' . $gat_blog_title['class'] : '';
								$gat_blog_title_link      = ! empty( $gat_blog_title['link'] ) ? $gat_blog_title['link'] : '';
								$gat_blog_title_link_text = ! empty( $gat_blog_title['link_text'] ) ? $gat_blog_title['link_text'] : '';
							} else {
								$gat_blog_title_text = $gat_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $gat_blog_title_class ); ?>">
								<?php
								$gat_top_icon = gat_get_term_image_small();
								if ( ! empty( $gat_top_icon ) ) {
									$gat_attr = gat_getimagesize( $gat_top_icon );
									?>
									<img src="<?php echo esc_url( $gat_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'gat' ); ?>"
										<?php
										if ( ! empty( $gat_attr[3] ) ) {
											gat_show_layout( $gat_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $gat_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $gat_blog_title_link ) && ! empty( $gat_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $gat_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $gat_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'gat_action_breadcrumbs' );
						$gat_breadcrumbs = ob_get_contents();
						ob_end_clean();
						gat_show_layout( $gat_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
